unit Nds;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     dialogs,
     Controls, 
     Buttons,
     StdCtrls, 
     ExtCtrls, 
     Nwtools, 
     Nwnds, 
     Nwlib, NWServer;

type
  TwinNDS = class(TForm)
    cancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    NDScontext: TEdit;
    NWTools1: TNWTools;
    binderyContext: TEdit;
    Label2: TLabel;
    NWLib1: TNWLib;
    serverDN: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    loginBtn: TButton;
    logoutBtn: TButton;
    root: TEdit;
    Label5: TLabel;
    myinfo: TMemo;
    attachBtn: TButton;
    createBtn: TButton;
    NWNDS1: TNWNDS;
    procedure FormShow(Sender: TObject);
    procedure loginBtnClick(Sender: TObject);
    procedure logoutBtnClick(Sender: TObject);
    procedure attachBtnClick(Sender: TObject);
    procedure createBtnClick(Sender: TObject);
    procedure listBtnClick(Sender: TObject);
    procedure contextChangeBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winNDS: TwinNDS;

implementation

{$R *.DFM}

uses
  ndsList,
  ndsCreat ;

procedure TwinNDS.FormShow(Sender: TObject);
  var
    nserver     : TNWConnHandle    ;
    attrRights  : TNWDSAttrRights  ;
    entryRights : TNWDSEntryRights ;
    smsRights   : TNWDSSMSRights   ;
  begin
    binderyContext.text := ndsGetBinderyContextName(getPrimaryServerID) ;
    serverDN.text       := ndsGetServerDN(getPrimaryServerID) ;
    root.text           := ndsGetRootName(ndsWhoAmI) ;
    ndscontext.text     := ndsGetContextName ;
    with myInfo.lines do begin
      clear ;
      add(ndsAbbreviateName(ndsWhoAmI)) ;
      add(whoAmI(0)) ;
      add(ndsGetObjID(0,ndsWhoAmI)) ;
    end;
  end;

procedure TwinNDS.loginBtnClick(Sender: TObject);
  var
    cpass,
    cUserID,
    contextName : string ;
  begin
    contextName := padR(ndsGetContextName,32,' ') ;
    cUserID     := padR(ndsWhoAmI,32,' ') ;
    cpass       := space(32) ;
    if inputQuery('NDS Login','Type Context String:',contextName) and
       inputQuery('NDS Login','Type Your Login ID:',cUserID) and
       inputQuery('NDS Login','Type Your Password:',cpass) then
      begin
        if ndsPassCheck(contextName,cUserID,cpass) and     { in case already logged in, } 
           ndsLogin(contextName,cUserID,cpass) then  { doesn't kill login on bad attempt}
          begin
            logoutBtn.enabled := True ;
            okBox('Login OK!') ;
          end
        else
          alertBox('Incorrect UserID/Password;;Try Again') ;
      end;
  end;

procedure TwinNDS.logoutBtnClick(Sender: TObject);
  begin
    if YesNoBox('Logging Out;;Are You Sure?') and
       ndsLogout then
      begin
        logoutBtn.enabled := False ;
        okBox('logged out!') ;
      end
    else
      alertBox('You Are Still Logged In') ;
  end;

procedure TwinNDS.attachBtnClick(Sender: TObject);
  var
    ctext : string ;
  begin
    ctext := getServerName(0) ;
    if inputQuery('Attach to DS Server','Type Server Name:',ctext) then
      if (ndsAttach(ctext) > 0) then
        okbox(ctext + ';Attached and Authenticated Successfully') 
      else
        alertBox('Error Attaching to Server!') ;
  end;

procedure TwinNDS.createBtnClick(Sender: TObject);
  begin
    try
      application.createForm(TWinNDSCreate,winNDSCreate) ;
      winNDSCreate.showModal ;
    finally
      winNDSCreate.free ;
      winNDSCreate := nil ;
    end;
  end;

procedure TwinNDS.listBtnClick(Sender: TObject);
  begin
    try
      application.createForm(TwinNDSList,winNDSList) ;
      with winNDSList do begin
        mainList.items.addStrings(ndsGetTreeList) ;
        showModal ;
      end;
    finally
      winNDSList.free ;
    end;
  end;

procedure TwinNDS.contextChangeBtnClick(Sender: TObject);
  begin
    if ndsSetContext(ndsContext.text) then
      begin
        formShow(sender) ;
        okBox('Context Set to ' + ndsContext.text) 
      end  
    else
      alertBox('Error Setting Context') ;  
  end;

end.
